
# Copyright 2017-2019 item Industrietechnik GmbH [http://www.item24.com]
# 
# This license is for the sample source code only:
# ----------------------------------------------------------------------------
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
# 
#      http://www.apache.org/licenses/LICENSE-2.0
# 
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.
# ----------------------------------------------------------------------------
# 
# The compiled libraries that come with this sample have their own license
# attached to them. Make sure you understand those licenses.
# 
# ObjectService can ONLY be legally used together with item ILMU hardware and
# ONLY for the creation of software used to control or analyze purchased item
# hardware. It may NOT under any circumstances be transmitted to other companies
# or entities unless prior permission was granted by item Industrietechnik GmbH.
# 
# ///////////////////////////////////////////////////////////////////////////////////////////////
# // WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - 
# ///////////////////////////////////////////////////////////////////////////////////////////////
# // DO NOT use this software on an unparametrized ILMU, because it may be destroyed
# // Make sure the ILMU is ready to be moved and that the machine is SAFE
# // Use the MotionSoft setup routine if you are not sure!
# //
# // To write into ObjectService registers, you can use the following code:
# // Controller.WriteComObject(Item.Ilmu.ObjectService.ComObjectType.BETRIEBSART, (int)Item.Ilmu.ObjectService.BetriebsArt.Positioning);
# //
# // DO NOT WRITE INTO ANY CONTROLLER REGISTERS IF YOU ARE NOT 100% SURE WHAT THEY DO!
# // Writing incorrect data into the registers will destroy the ILMU hardware if you try to move
# ///////////////////////////////////////////////////////////////////////////////////////////////
# // WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - WARNING - 
# ///////////////////////////////////////////////////////////////////////////////////////////////

# Python remarks:
# 
# - This code uses pythonnet to load in the .NET DLL, you need to install the module via PIP
# - Python is a very, very bad language to use for something like this, as it is missing Intellisense, has incompatible multithreading support and lots of performance problems
# - You should really use C# to implement your code, because it is easier to use, safer, and faster to develop in than Python
# - Keep in mind that almost every C# function you call is normally using the async/await pattern, so they will not work multithreaded like they should
# - Python may be too slow to keep up with the C# DLL callbacks, so you have to take care of that and increase the subscription interval

import clr
import time
import msvcrt

clr.AddReference("Item.Ilmu.ObjectService")
clr.AddReference('System')

from System import *
from Item.Ilmu.ObjectService import *

service = ObjectService(ObjectServiceMode.OnlyMovement_ReadWrite, LoggingMode.Debug | LoggingMode.Info | LoggingMode.Success | LoggingMode.Warn, False)

LastReglerfreigabe = False
LastActualPos = 0
LastActualSpeed = 0

def OnServiceConnected(sender):

    print ("ILMU connected")

    print ("-> Subscriptions to 250ms")
    service.AlwaysReadInterval = 250
    
    print ("-> ClearWarningsAndErrors")
    service.ClearWarningsAndErrors()
    
    time.sleep(1)
    
    print ("-> ReglerFreigabeSelector")
    service.SetClearanceSelector(ReglerFreigabeSelector.DIN5AndPC)
    
    time.sleep(1)
    
    print ("-> EnableController")
    service.SendDeviceCommandToController(IlmuCmd.EnableController)

def OnServiceDisconnected(sender):

    print ("ILMU Disconnected")

def OnLogMessage(sender, e):

    print ("Log: " + e.Message + " [" + repr(e.ErrorCode) + "]")

def OnMovementStatusChanged (sender):

    #print ("MoveStatus: " + repr(service.MovementStatus) + " | MoveMode: " + repr(service.MovementMode))
    pass

def OnErrorsReported (sender, e):

    if e.Count > 0:
        print (repr(e.Count) + " Errors: " + String.Join(", ", e))

# This provides continuous updates of POSACTUAL
def OnRegisterChanged (sender, e):

    global LastReglerfreigabe
    global LastActualPos
    global LastActualSpeed

    #print ("Register: " + e.Name + " -> " + repr(e.Value))

    if e.ID == ComObjectType.STATUSWORD:

        if (e.Value & StatusWord.Reglerfreigabe) != 0:
            if not LastReglerfreigabe:
                print ("Controller ENABLED")
            LastReglerfreigabe = True
        else:
            if LastReglerfreigabe:
                print ("Controller DISABLED")
            LastReglerfreigabe = False

    elif e.ID == ComObjectType.POSACTUAL:

        if abs (LastActualPos - e.Value) > 1:

            #print ("Pos: " + "%0.f" % (e.Value))
            LastActualPos = e.Value

    elif e.ID == ComObjectType.SPEEDACTUAL:

        if abs (LastActualSpeed - e.Value) > 1:

            #print ("Speed: " + "%0.f" % (e.Value))
            LastActualSpeed = e.Value

class ControllerHeartbeat():

    global service

    # These events usually run on another thread
    service.Connected += OnServiceConnected
    service.Disconnected += OnServiceDisconnected
    service.LogMessage += OnLogMessage
    service.MovementStatusChanged += OnMovementStatusChanged
    service.RegisterChanged += OnRegisterChanged
    service.ErrorsReported += OnErrorsReported

    print ("-------------------------------------------")
    print ("- Press key 'r' for Referencing           -")
    print ("- Press keys '1-5' for moving to 0-200    -")
    print ("- Press key 'p' to get POSACTUAL          -")
    print ("- Press key 'q' to quit                   -")
    print ("-------------------------------------------")

    # We are using blocking calls here, which we shouldnt
    # If we use Async calls, Python will blow up
    print ("-> Connect")
    service.Connect(ComDeviceType.AUTO, "192.168.0.82", 8802, "AUTO", 0)

    try:
        while True:
            
            if service.IsConnected:
                
                if service.HasError:

                    print ("-> ClearWarningsAndErrors")
                    service.ClearWarningsAndErrors()
                    time.sleep(1)
                
                elif (service.ILMUStatus & StatusWord.Reglerfreigabe) == 0:

                    print ("-> EnableController")
                    service.SendDeviceCommandToController(IlmuCmd.EnableController)
                    time.sleep(1)

                elif msvcrt.kbhit():

                   key = msvcrt.getch()
                   
                   if (key == b'r'):
                    
                       print ("-> Referencing")
                       service.StartReferencing();
                    
                   elif (key == b'1'):

                        # These calls are blocking, they return when the position is reached
                        # There is an Async version that does not block, but Python cant handle it
                        print ("-> MoveToPosition 0")
                        service.SendMovementCommandToController(MovementMode.MoveToPosition, 0, 100, 3000)

                   elif (key == b'2'):

                        print ("-> MoveToPosition 50")
                        service.SendMovementCommandToController(MovementMode.MoveToPosition, 50, 100, 3000)

                   elif (key == b'3'):

                        print ("-> MoveToPosition 100")
                        service.SendMovementCommandToController(MovementMode.MoveToPosition, 100, 100, 3000)

                   elif (key == b'4'):

                        print ("-> MoveToPosition 150")
                        service.SendMovementCommandToController(MovementMode.MoveToPosition, 150, 100, 3000)

                   elif (key == b'5'):

                        print ("-> MoveToPosition 200")
                        service.SendMovementCommandToController(MovementMode.MoveToPosition, 200, 100, 3000)

                   elif (key == b'p'):

                        print ("POSACTUAL: " + repr(service.GetComObjectValue(ComObjectType.POSACTUAL)))

                   elif (key == b'q'):

                        print ("-> DisableController")
                        service.SendDeviceCommandToController(IlmuCmd.DisableController)

                        time.sleep(0.25)

                        print ("-> Disconnect")
                        service.Disconnect()

                        break
            else:

                time.sleep(1)
        
    except KeyboardInterrupt:

        print ("-> DisableController")
        service.SendDeviceCommandToController(IlmuCmd.DisableController)

        time.sleep(1)

        print ("-> Disconnect")
        service.Disconnect()


if __name__ == "__main__":

    try:
        app = MyApplication(service)
        app.run()
        exit()

    except:
        pass